package gov.va.med.mhv.integration.phr.dao;

import gov.va.med.mhv.integration.phr.stage.transfer.StageAdmissionsAndDischarges;
import gov.va.med.mhv.integration.phr.stage.transfer.StageDemographics;
import gov.va.med.mhv.integration.phr.stage.transfer.StageEKG;
import gov.va.med.mhv.integration.phr.stage.transfer.StageEntityAK;
import gov.va.med.mhv.integration.phr.stage.transfer.StageImmunization;
import gov.va.med.mhv.integration.phr.stage.transfer.StageMicrobiology;
import gov.va.med.mhv.integration.phr.stage.transfer.StagePathology;
import gov.va.med.mhv.integration.phr.stage.transfer.StageProblemList;
import gov.va.med.mhv.integration.phr.stage.transfer.StageProgressNotes;
import gov.va.med.mhv.integration.phr.stage.transfer.StageRadiology;
import gov.va.med.mhv.integration.phr.stage.transfer.StageVitals;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;

public interface PhrVPRDAO extends PhrBaseDAO {

	// Begin Transfer Routines
	public abstract long deletePHRImmunizationFromEvault(String icn)
			throws SQLException;

	/**
	 * This method is responsible to transfer the new Immunization records
	 * (Immunization, comments, reaction, location_name, etc) into evault.
	 *
	 * It first updates the status to "PROCESSING";
	 *
	 * @param ak
	 * @param currentStatus
	 * @return
	 * @throws SQLException
	 */
	public abstract int loadImmunizations(StageEntityAK ak,
			String currentStatus, List<StageImmunization> records)
			throws SQLException;

	public abstract int loadProblemLists(StageEntityAK ak, String new1,
			List<StageProblemList> records);

	// Begin Transfer Routines
	public abstract long deletePHRProblemListFromEvault(String icn)
			throws SQLException;

	public abstract int loadRadiology(StageEntityAK ak, String new1,
			List<StageRadiology> records);

	public abstract long deletePHRRadiologyFromEvault(String icn)
			throws SQLException;

	public abstract int loadProgressNotes(StageEntityAK ak, String new1,
			List<StageProgressNotes> records);

	/**
     * 
     * WIPE ALL PROGRESS NOTES RECORDS
     * 
     * @param icn
     * @param records
     * @return
     * @throws SQLException
     */
	public abstract long deletePHRProgressNotesFromEvault(String icn)
			throws SQLException;

	/**
	 * This method is responsible to transfer the new Vitals records
	 * (Location_Name, Vitals Type, comments, Measurement,  etc) into evault.
	 *
	 * It first updates the status to "PROCESSING";
	 *
	 * @param ak
	 * @param currentStatus
	 * @return
	 * @throws SQLException
	 */
	public abstract int loadVitals(StageEntityAK ak, String currentStatus,
			List<StageVitals> records) throws SQLException;

	// Begin Transfer Routines
	public abstract long deletePHRVitalsFromEvault(String icn)
			throws SQLException;

	public abstract int loadDemographics(StageEntityAK ak, String new1,
			List<StageDemographics> records);

	public abstract long deletePHRDemographicsFromEvault(String icn)
			throws SQLException;

	public abstract int loadMicrobiology(StageEntityAK ak, String new1,
			List<StageMicrobiology> records);

	public abstract long deletePHRMicrobiologyFromEvault(String icn)
			throws SQLException;

	public abstract int loadPathology(StageEntityAK ak, String new1,
			List<StagePathology> records);

	public abstract long deletePHRPathologyFromEvault(String icn)
			throws SQLException;

	/**
	 * This method is responsible to transfer the new Admissions And Discharges records
	 * PHR_ADMISSIONSANDDISCHARGES_ID
	 * OPLOCK
	 * PATIENT_ID
	 * CREATED_DATE
	 * STATION_NUMBER
	 * PHR_FACILITY_CONTROL_ID
	 * FACILITY_INFO_ID
	 *
	 * Specific fields for this domain
	 * ADMISSION_DATE_TIME
	 * ADMITTING_SPECIALITY
	 * ADMITTING_PHYSICIAN
	 * DISCHARGE_DATE_TIME
	 * DISCHARGE_PHYSICIAN
	 * DISCHARGE_SUMMARY
	 * VISIT_ENCOUNTER_ID
	 * into evault.
	 *
	 * It first updates the status to "PROCESSING";
	 * @param ak
	 * @param currentStatus
	 * @return
	 * @throws SQLException
	 */
	public abstract int loadAdmissionsDischarges(StageEntityAK ak,
			String currentStatus, List<StageAdmissionsAndDischarges> records)
			throws SQLException;

	// Begin Transfer Routines
	public abstract long deletePHRAdmissionsDischargesFromEvault(String icn)
			throws SQLException;

	public abstract Hashtable<String, Long> fetchFacilityInfoIds(String icn);

	public abstract Hashtable<String, Long> fetchPhrFacilityControlIds(
			String icn);

	public abstract long deletePHREKG(String icn) throws SQLException;

	/**
	 * This method is responsible to transfer the new EKG records
	 * into evault.
	 *
	 * It first updates the status to "PROCESSING";
	 *
	 * @param ak
	 * @param currentStatus
	 * @return
	 * @throws SQLException
	 */
	public abstract int loadEKG(StageEntityAK ak, String currentStatus,
			List<StageEKG> records) throws SQLException;

}